<!-- Modal Ubah User -->
<div class="modal fade" id="ubahUser<?php echo e($item->id); ?>" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content shadow-lg border-0">

            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title">
                    <i class="fas fa-user-edit me-2"></i> Ubah User
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <form action="<?php echo e(route('admin.user.update', $item->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="modal-body">

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Nama Lengkap</label>
                        <input type="text" name="nama" class="form-control"
                               value="<?php echo e($item->nama); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Email</label>
                        <input type="email" name="email" class="form-control"
                               value="<?php echo e($item->email); ?>" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Password</label>
                        <input type="password" name="password" class="form-control"
                               placeholder="Kosongkan jika tidak diubah">
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Role</label>
                        <select name="role" class="form-select" required>
                            <option value="super_admin" <?php echo e($item->role == 'super_admin' ? 'selected' : ''); ?>>Super Admin</option>
                            <option value="admin" <?php echo e($item->role == 'admin' ? 'selected' : ''); ?>>Admin</option>
                            <option value="karyawan" <?php echo e($item->role == 'karyawan' ? 'selected' : ''); ?>>Karyawan</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Status</label>
                        <select name="status" class="form-select">
                            <option value="aktif" <?php echo e($item->status == 'aktif' ? 'selected' : ''); ?>>Aktif</option>
                            <option value="nonaktif" <?php echo e($item->status == 'nonaktif' ? 'selected' : ''); ?>>Nonaktif</option>
                        </select>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        Batal
                    </button>
                    <button type="submit" class="btn btn-warning">
                        Simpan Perubahan
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>
<?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/admin/user/edit.blade.php ENDPATH**/ ?>